package sk.kosice.konto.kknotificationservice.recipient;

import io.restassured.http.ContentType;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kknotificationservice.ServiceAppFeatureSpec;
import sk.kosice.konto.kknotificationservice.restapi.controller.RecipientController;
import sk.kosice.konto.kknotificationservice.restapi.dto.recipient.CreateOrUpdateRecipientRequest;
import sk.kosice.konto.kknotificationservice.restapi.dto.recipient.RecipientDetailResponse;

public abstract class RecipientFeatureSpec extends ServiceAppFeatureSpec {

  protected <T> T getRecipient(UUID kid, HttpStatus status, Class<T> response) {
    return requestSpecification()
        .when()
        .auth()
        .oauth2(JWT_TECHNICAL_TOKEN)
        .get(RecipientController.RECIPIENT_URI, kid)
        .then()
        .log()
        .all()
        .statusCode(status.value())
        .contentType(ContentType.JSON)
        .extract()
        .as(response);
  }

  protected <T> T createOrUpdateRecipient(
      UUID kid, CreateOrUpdateRecipientRequest request, HttpStatus httpStatus, Class<T> response) {
    return requestSpecification()
        .when()
        .auth()
        .oauth2(JWT_TECHNICAL_TOKEN)
        .body(request)
        .put(RecipientController.RECIPIENT_URI, kid)
        .then()
        .log()
        .all()
        .statusCode(httpStatus.value())
        .contentType(ContentType.JSON)
        .extract()
        .body()
        .as(response);
  }

  protected RecipientDetailResponse createOrUpdateRecipient(
      UUID kid, CreateOrUpdateRecipientRequest request) {
    return createOrUpdateRecipient(kid, request, HttpStatus.OK, RecipientDetailResponse.class);
  }
}
