package sk.kosice.konto.kknotificationservice.domain.businessconfig;

import static sk.kosice.konto.kknotificationservice.domain.shared.enumeration.Role.ADMIN;

import org.immutables.value.Value;
import sk.kosice.konto.kknotificationservice.domain.shared.enumeration.Role;

@Value.Immutable
public interface BusinessConfig {

  String senderEmail();

  String senderName();

  Integer messagesLimit();

  String adminRoleId();

  default String getRoleIdByName(Role name) {
    return switch (name) {
      case ADMIN -> adminRoleId();
    };
  }
}
