import type { Metadata } from 'next';
import { auth } from '@/auth';
import { Providers, Navigation, Header, SessionError } from '@/components';
import '@/styles/index.css';

export const metadata: Metadata = {
  title: 'Správca Košice',
  description: 'Admin portál správcu mesta Košice'
};

export default async function RootLayout({
  children
}: Readonly<{
  children: React.ReactNode;
}>) {
  const session = await auth();
  const sessionError = session?.error;

  return (
    <html lang="sk">
      <Providers session={session}>
        <body className="flex flex-col h-screen w-screen bg-neutral-100">
          <Header />

          <div className="flex flex-row pt-[7.5rem] h-full w-full">
            <aside className="fixed hidden dm1:block top-[7.5rem] left-0 h-[calc(100vh-7.5rem)] w-[15%] border-r border-neutral-300 bg-white">
              <Navigation />
            </aside>

            <main className="dm1:ml-[15%] h-[calc(100vh-7.5rem)] w-full overflow-y-auto p-6">
              {sessionError ? <SessionError error={sessionError} /> : children}
            </main>
          </div>
        </body>
      </Providers>
    </html>
  );
}
