package sk.kosice.konto.kknotificationservice.mailjet;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import com.mailjet.client.MailjetClient;
import com.mailjet.client.MailjetRequest;
import com.mailjet.client.MailjetResponse;
import com.mailjet.client.errors.MailjetException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import sk.kosice.konto.kknotificationservice.business.email.port.outbound.EmailSenderPort;
import sk.kosice.konto.kknotificationservice.mailjet.configuration.properties.MailjetClientPropertiesPort;

@ExtendWith(SpringExtension.class)
@SpringBootTest(
    classes = SpringMailjetTestApp.class,
    properties = "spring.main.allow-bean-definition-overriding=true")
public abstract class MailjetClientAdapterTest {

  @MockitoBean protected MailjetClient mailjetClient;
  @MockitoBean protected MailjetClientPropertiesPort mailjetClientPropertiesPort;
  @Autowired protected EmailSenderPort emailSenderPort;

  @BeforeEach
  public void setUp() throws MailjetException {
    when(mailjetClientPropertiesPort.apiKey()).thenReturn("apiKey");
    when(mailjetClientPropertiesPort.secretKey()).thenReturn("secretKey");

    final var response = mock(MailjetResponse.class);
    when(response.getStatus()).thenReturn(200);

    doReturn(response).when(mailjetClient).post(any(MailjetRequest.class));
  }

  public void prepareClient400Response() throws MailjetException {
    final var response = mock(MailjetResponse.class);
    when(response.getStatus()).thenReturn(400);
    when(response.getRawResponseContent()).thenReturn("400");

    doReturn(response).when(mailjetClient).post(any(MailjetRequest.class));
  }

  public void prepareClient401Response() throws MailjetException {
    final var response = mock(MailjetResponse.class);
    when(response.getStatus()).thenReturn(401);

    doReturn(response).when(mailjetClient).post(any(MailjetRequest.class));
  }

  public void prepareClient403Response() throws MailjetException {
    final var response = mock(MailjetResponse.class);
    when(response.getStatus()).thenReturn(403);

    doReturn(response).when(mailjetClient).post(any(MailjetRequest.class));
  }

  public void prepareClient500Response() throws MailjetException {
    final var response = mock(MailjetResponse.class);
    when(response.getStatus()).thenReturn(500);
    when(response.getRawResponseContent()).thenReturn("500");

    doReturn(response).when(mailjetClient).post(any(MailjetRequest.class));
  }
}
