package sk.kosice.konto.kknotificationservice.domain.recipient.query;

import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kknotificationservice.domain.common.ActorIdentity;
import sk.kosice.konto.kknotificationservice.domain.common.marker.AuditableQuery;

@Value.Immutable
public interface FindRecipientByIdQuery extends AuditableQuery {

  UUID kid();

  static FindRecipientByIdQuery of(UUID kid, Optional<ActorIdentity> actorId) {
    return ImmutableFindRecipientByIdQuery.builder().kid(kid).actorId(actorId).build();
  }
}
