import React from 'react';
import { GenericAction, PayBySquareAction } from '@/components';
import { MessageAction } from '@/utils';

interface MessageDetailActionProps {
  action: MessageAction;
}

const MessageDetailAction: React.FC<MessageDetailActionProps> = ({ action }) => {
  if (action.type === 'SHOW_PAY_QR_CODE' || action.type === 'OPEN_PAY_BY_CARD_URL') {
    return <PayBySquareAction action={action} />;
  }
  return <GenericAction action={action} />;
};

export default MessageDetailAction;
