'use client';

import React from 'react';
import UserHeader from './UserHeader';
import LogoKosice from '@/assets/logo_kosice.svg';
import { Logo } from '@/lib/idsk';
import Link from 'next/link';

const Header: React.FC = () => {
  return (
    <header className="fixed top-0 left-0 h-[7.5rem] bg-white border-b border-neutral-300 w-full z-40">
      <div className="bg-blue-500 py-3 px-7"></div>
      <div className="p-7 w-full flex justify-between items-center">
        <Link href="/">
          <Logo title="Správca Košice" image={<LogoKosice />}></Logo>
        </Link>
        <UserHeader />
      </div>
    </header>
  );
};

export default Header;
