'use client';

import { SnackbarProps, SnackbarStack } from '@/lib/idsk';
import React, { useState } from 'react';
import { NotificationsContext } from '@/context';

interface NotificationsProviderProps {
  children: React.ReactNode;
}

const NotificationsProvider: React.FC<NotificationsProviderProps> = ({ children }) => {
  const [notifications, setNotifications] = useState<SnackbarProps[]>([]);

  return (
    <NotificationsContext.Provider value={{ notifications, setNotifications }}>
      {children}
      <SnackbarStack snackbars={notifications} setSnackbars={setNotifications} />
    </NotificationsContext.Provider>
  );
};

export default NotificationsProvider;
