import axios from 'axios';

export const getCurrentUnixTime = () => Math.floor(new Date().getTime() / 1000);

export const isExpired = (expiresOn: number) => getCurrentUnixTime() + 60 > expiresOn;

export const refreshToken = async (typedToken: any) => {
  const tokenEndpoint = process.env.AZURE_AD_TOKEN_URL;

  if (!tokenEndpoint) {
    throw new Error('AZURE_AD_TOKEN_URL environment variable must be specified.');
  }

  const response = await axios.post(
    tokenEndpoint,
    {},
    {
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      },
      params: {
        grant_type: 'refresh_token',
        client_id: process.env.AZURE_AD_CLIENT_ID,
        client_secret: process.env.AZURE_AD_CLIENT_SECRET,
        refresh_token: typedToken.refreshToken,
        scope: process.env.AZURE_AD_SCOPE
      }
    }
  );

  return {
    ...typedToken,
    accessToken: response.data.access_token,
    refreshToken: response.data.refresh_token || typedToken.refreshToken,
    expiresOn: response.data.expires_on
  };
};
