import React from 'react';
import { useTranslations } from 'next-intl';
import { ErrorDialog, PrimaryButton, SecondaryButton } from '@/lib/idsk';
import { Organization } from '@/types';
import { useDeleteSubscription } from '@/hooks';

interface SubscriptionDeleteDialogProps {
  userId: string;
  organization: Organization;
  onClose: () => void;
}

const SubscriptionDeleteDialog: React.FC<SubscriptionDeleteDialogProps> = ({ userId, organization, onClose }) => {
  const mutation = useDeleteSubscription(userId, organization.id, onClose);
  const t = useTranslations('profile_page');

  const handleClose = () => {
    onClose();
  };

  const organizationType = organization.isCityDistrict ? 'district' : 'organization';

  return (
    <ErrorDialog className="error-dialog--custom" opened title={t(`delete_title_${organizationType}`)} img={null}>
      <p>{t(`delete_description_${organizationType}`)}</p>
      <PrimaryButton variant="warning" disabled={mutation.isPending} onClick={() => mutation.mutate()}>
        {t('yes_delete')}
      </PrimaryButton>
      <SecondaryButton onClick={handleClose}>{t('cancel')}</SecondaryButton>
    </ErrorDialog>
  );
};

export default SubscriptionDeleteDialog;
