import axios from 'axios';
import { useMutation } from '@tanstack/react-query';
import { api } from '@/utils';

const updateSubscription = async (userId: string, postData: string[]) => {
  const { data } = await axios.post(api.subscriptions(userId), { organizations: postData });
  return data;
};

const useUpdateSubscriptions = (options?: any) =>
  useMutation({
    ...options,
    mutationKey: ['subscriptions'],
    mutationFn: (data: { userId: string; items: string[] }) => updateSubscription(data.userId, data.items)
  });

export default useUpdateSubscriptions;
