import axios from 'axios';
import { baseUrl, headers } from '../api/server';
import { api, Page, Permission, Result } from '../api';
import { getRequestError } from '../api/error';

export async function getOrganization(id: string, token: string): Promise<Result<Page<Permission>>> {
  try {
    const response = await axios.get<Page<Permission>>(`${baseUrl('kkmessage')}${api.organizationsByOid(id)}`, {
      headers: await headers({
        Authorization: `Bearer ${token}`
      })
    });
    return {
      data: response.data,
      error: undefined
    };
  } catch (err: unknown) {
    const error = getRequestError(err);

    return {
      data: undefined,
      status: error.status,
      error
    };
  }
}
