package sk.kosice.konto.kkmessageservice.repository;

import jakarta.annotation.PostConstruct;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jooq.JooqAutoConfiguration;

@SpringBootApplication(
    scanBasePackageClasses = SpringPersistentTestApp.class,
    exclude = JooqAutoConfiguration.class)
public class SpringPersistentTestApp {

  @PostConstruct
  public void init() {
    TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    System.out.println("Spring boot application running in UTC timezone :" + new Date());
  }
}
