package sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import sk.kosice.konto.kkmessageservice.domain.common.listing.common.ListingAttribute;
import sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc.annotation.FilterParameter;

@Component
public class FilterParameterCustomizer implements ParameterCustomizer {

  private static Map<String, String> attrNotes =
      Map.of(
          "updatedAt",
          "A date-time with an offset from UTC in the ISO-8601 calendar system, example: 2000-04-19T00:00:00+00:00",
          "createdAt",
          "A date-time with an offset from UTC in the ISO-8601 calendar system, example: 2000-04-19T00:00:00+00:00",
          "validFrom",
          "A date-time without a time-zone in the ISO-8601 calendar system, example: 2000-04-18",
          "validThru",
          "A date-time without a time-zone in the ISO-8601 calendar system, example: 2000-04-18");

  @Override
  public Parameter customize(Parameter parameterModel, MethodParameter methodParameter) {
    FilterParameter annotation = methodParameter.getParameterAnnotation(FilterParameter.class);
    if (annotation != null) {
      prepareFilteringAttributes(annotation.listingAttributeClass());
      parameterModel.description(
          parameterModel.getDescription()
              + "<b>Supported filter attributes:</b> "
              + prepareFilteringAttributes(annotation.listingAttributeClass())
              + prepareFilteringAttrNote(annotation.listingAttributeClass()));
      parameterModel.example(
          annotation.example().equals("")
              ? prepareFilteringExample(annotation.listingAttributeClass())
              : annotation.example());
    }
    return parameterModel;
  }

  private static <E extends Enum & ListingAttribute> String prepareFilteringAttributes(
      Class<? extends Enum<? extends ListingAttribute>> clazz) {
    try {
      final Method method = clazz.getDeclaredMethod("values");
      return Arrays.stream((E[]) method.invoke(true))
          .filter(ListingAttribute::isForFiltering)
          .map(ListingAttribute::apiName)
          .collect(Collectors.joining(", "));
    } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
      return "";
    }
  }

  private static <E extends Enum & ListingAttribute> String prepareFilteringAttrNote(
      Class<? extends Enum<? extends ListingAttribute>> clazz) {
    try {
      final Method method = clazz.getDeclaredMethod("values");
      String attrDescription =
          Arrays.stream((E[]) method.invoke(true))
              .filter(ListingAttribute::isForFiltering)
              .filter(e -> attrNotes.containsKey(e.apiName()))
              .map(e -> e.apiName() + " : " + attrNotes.get(e.apiName()))
              .collect(Collectors.joining("<br /> "));

      if (!Objects.isNull(attrDescription) && !attrDescription.isEmpty())
        return "<br /> <i>Note:</i><br /> ".concat(attrDescription);
      return "";
    } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
      return "";
    }
  }

  private static <E extends Enum & ListingAttribute> String prepareFilteringExample(
      Class<? extends Enum<? extends ListingAttribute>> clazz) {
    try {
      final Method method = clazz.getDeclaredMethod("values");
      return Arrays.stream((E[]) method.invoke(true))
          .filter(ListingAttribute::isForFiltering)
          .map(a -> a.apiName() + "=in=(\"A1\", \"A2\")")
          .findFirst()
          .orElse("");
    } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
      return "";
    }
  }
}
