package sk.kosice.konto.kkmessageservice.restapi.mapper;

import java.util.List;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ListOfSubscriptions;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.BaseOrganization;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.BaseTopic;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.ImmutableSubscriptionDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.ImmutableSubscriptionListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionListResponse;

public class SubscriptionResponseMapper {

  public static SubscriptionDetailResponse map(SubscriptionEntity entity) {
    return ImmutableSubscriptionDetailResponse.builder()
        .id(entity.id())
        .isEmailEnabled(entity.isEmailEnabled())
        .recipientKid(entity.recipientKid())
        .topic(
            new BaseTopic(entity.topic().id(), entity.topic().name(), entity.topic().description()))
        .organization(
            new BaseOrganization(entity.organization().id(), entity.organization().name()))
        .build();
  }

  public static List<SubscriptionDetailResponse> map(List<SubscriptionEntity> entities) {
    return entities.stream().map(SubscriptionResponseMapper::map).toList();
  }

  public static SubscriptionListResponse map(ListOfSubscriptions subscriptions) {
    return ImmutableSubscriptionListResponse.builder()
        .totalCount(subscriptions.totalCount())
        .page(subscriptions.page())
        .pageSize(subscriptions.pageSize())
        .addAllItems(subscriptions.items().stream().map(SubscriptionResponseMapper::map).toList())
        .build();
  }
}
