package sk.kosice.konto.kkmessageservice.subscription;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kkmessageservice.restapi.dto.subscription.SubscriptionDetailResponse;

public class SubscriptionCreateFeatureSpec extends SubscriptionFeatureSpec {

  @Test
  public void thatSubscriptionsCanBeUpdatedInBatch() {
    final List<UUID> topics = prepareTopics();
    prepareRecipient(UUID.fromString(EXTENSION_KID_CLAIM));

    final List<SubscriptionDetailResponse> result =
        List.of(
            createSubscriptions(
                HttpStatus.CREATED,
                UUID.fromString(EXTENSION_KID_CLAIM),
                SubscriptionDetailResponse[].class,
                SubscriptionApiFixtures.subscriptionCreateByOrganizationIdRequest(
                    ORGANIZATION_ID_1)));
    assertThat(result).isNotNull().isNotEmpty().hasSize(3);
    result.forEach(
        r -> {
          assertThat(r.getRecipientKid()).isEqualTo(UUID.fromString(EXTENSION_KID_CLAIM));
          assertThat(topics).contains(r.getTopic().id());
        });
  }
}
