'use client';

import React, { useEffect } from 'react';
import { signIn } from 'next-auth/react';
import { redirect, useSearchParams } from 'next/navigation';

const SignInPage: React.FC = () => {
  const params = useSearchParams();
  const provider = params.get('provider') || 'microsoft-entra-id';
  const locale = params.get('ui_locales') || 'sk';
  const error = params.get('error');

  // eslint-disable-next-line consistent-return
  useEffect(() => {
    if (error) {
      return redirect('/uvod');
    }

    signIn(provider, { callbackUrl: '/' }, { ui_locales: locale });
  }, [provider, error, locale]);

  return null;
};

export default SignInPage;
