'use client';

import { Page, Topic } from '@/utils';
import {
  DataGrid,
  DataGridRow,
  DataGridRowValue,
  TextButton,
  EditIcon,
  TertiaryIconButton,
  DeleteIcon
} from '@/lib/idsk';
import React from 'react';
import TopicsListHeader from './TopicsListHeader';
import TopicsListPlaceholder from './TopicsListPlaceholder';
import { Empty } from '@/components';

interface TopicsListProps {
  data: Page<Topic>;
  sort: 'asc' | 'desc';
  onSortChange: () => void;
  onUpdateClick: (item: Topic) => void;
  onDeleteClick: (item: Topic) => void;
}

const TopicsList: React.FC<TopicsListProps> = ({ sort, data, onSortChange, onUpdateClick, onDeleteClick }) => {
  if (data.items.length === 0) {
    return (
      <TopicsListPlaceholder>
        <div className="px-12 py-16 bg-white rounded-b-lg border-t border-neutral-300">
          <Empty title="Zatiaľ nemáte žiadne témy" />
        </div>
      </TopicsListPlaceholder>
    );
  }

  return (
    <DataGrid className="custom-datagrid" headRow={<TopicsListHeader sort={sort} onSortChange={onSortChange} />}>
      {data.items.map((item: Topic) => (
        <DataGridRow key={item.id} className="flex flex-col tb2:grid tb2:grid-cols-12">
          <DataGridRowValue className="col-span-3 font-bold tb2:font-normal">{item.name}</DataGridRowValue>
          <DataGridRowValue className="col-span-6 text-txt-grey">{item.description}</DataGridRowValue>
          <DataGridRowValue align="right" className="flex justify-between tb2:justify-end col-span-3">
            <TextButton icon={<EditIcon />} onClick={() => onUpdateClick(item)}>
              Upraviť
            </TextButton>
            <TertiaryIconButton icon={<DeleteIcon />} variant="warning" onClick={() => onDeleteClick(item)} />
          </DataGridRowValue>
        </DataGridRow>
      ))}
    </DataGrid>
  );
};

export default TopicsList;
