package sk.kosice.konto.kkmessageservice.idp;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import com.microsoft.graph.groups.GroupsRequestBuilder;
import com.microsoft.graph.groups.item.GroupItemRequestBuilder;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.GroupCollectionResponse;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import sk.kosice.konto.kkmessageservice.idp.config.properties.AzureIdpPropertiesPort;

@ExtendWith(SpringExtension.class)
@SpringBootTest(
    classes = SpringAzureIdpTestApp.class,
    properties = "spring.main.allow-bean-definition-overriding=true")
@ActiveProfiles("test")
public abstract class AzureIdpAdapterTest {
  protected static final String ROOT_GROUP_ID = "5a9dd9a3-d8ee-4377-8c23-76fc793bac04";

  @Autowired protected AzureIdpRepository azureIdpRepository;

  @MockBean private GraphServiceClient graphServiceClient;
  @MockBean private AzureIdpPropertiesPort azureIdpPropertiesPort;

  public void prepareListResponse() {
    final var group1 = mock(Group.class);
    doReturn(UUID.randomUUID().toString()).when(group1).getId();
    doReturn(UUID.randomUUID().toString()).when(group1).getDisplayName();

    final var group2 = mock(Group.class);
    doReturn(UUID.randomUUID().toString()).when(group2).getId();
    doReturn(UUID.randomUUID().toString()).when(group2).getDisplayName();

    final var group3 = mock(Group.class);
    doReturn(UUID.randomUUID().toString()).when(group3).getId();
    doReturn(UUID.randomUUID().toString()).when(group3).getDisplayName();

    final var response = mock(GroupCollectionResponse.class);
    doReturn(List.of(group1, group2, group3)).when(response).getValue();

    final var request = mock(GroupsRequestBuilder.class);
    doReturn(response).when(request).get(any());

    doReturn(request).when(graphServiceClient).groups();
  }

  public void prepareListByRootGroupResponse() {
    final var member1Id = UUID.randomUUID();
    final var member2Id = UUID.randomUUID();

    final var member1 = mock(DirectoryObject.class);
    doReturn(member1Id.toString()).when(member1).getId();

    final var member2 = mock(DirectoryObject.class);
    doReturn(member2Id.toString()).when(member2).getId();

    final var rootGroup = mock(Group.class);
    doReturn(List.of(member1, member2)).when(rootGroup).getMembers();

    final var itemRootRequest = mock(GroupItemRequestBuilder.class);
    doReturn(rootGroup).when(itemRootRequest).get();

    final var rootRequest = mock(GroupsRequestBuilder.class);
    doReturn(itemRootRequest).when(rootRequest).byGroupId(ROOT_GROUP_ID);

    final var group1 = mock(Group.class);
    doReturn(member1Id.toString()).when(group1).getId();
    doReturn(UUID.randomUUID().toString()).when(group1).getDisplayName();

    final var group2 = mock(Group.class);
    doReturn(member2Id.toString()).when(group2).getId();
    doReturn(UUID.randomUUID().toString()).when(group2).getDisplayName();

    final var itemRequest1 = mock(GroupItemRequestBuilder.class);
    doReturn(group1).when(itemRequest1).get();

    final var request1 = mock(GroupsRequestBuilder.class);
    doReturn(itemRequest1).when(request1).byGroupId(member1Id.toString());

    final var itemRequest2 = mock(GroupItemRequestBuilder.class);
    doReturn(group1).when(itemRequest2).get();

    final var request2 = mock(GroupsRequestBuilder.class);
    doReturn(itemRequest2).when(request2).byGroupId(member2Id.toString());

    when(graphServiceClient.groups())
        .thenReturn(rootRequest)
        .thenReturn(request1)
        .thenReturn(request2);
  }

  public void prepareFindOneResponse(UUID organizationId) {
    final var group = mock(Group.class);
    doReturn(organizationId.toString()).when(group).getId();
    doReturn("groupName").when(group).getDisplayName();

    final var itemRequest = mock(GroupItemRequestBuilder.class);
    doReturn(group).when(itemRequest).get();

    final var request = mock(GroupsRequestBuilder.class);
    doReturn(itemRequest).when(request).byGroupId(organizationId.toString());

    when(graphServiceClient.groups()).thenReturn(request);
  }
}
