package sk.kosice.konto.kkmessageservice.repository.recipient.error.constraint;

import sk.kosice.konto.kkmessageservice.domain.recipient.entity.RecipientEntity;
import sk.kosice.konto.kkmessageservice.repository.error.ConstraintErrorCode;
import sk.kosice.konto.kkmessageservice.repository.model.Keys;
import sk.kosice.konto.kkmessageservice.repository.model.Tables;

public enum RecipientConstraintErrorCode implements ConstraintErrorCode {
  RECIPIENT_WITH_ID_ALREADY_EXISTS("Recipient with kid '%s' already exists.") {
    @Override
    public String constraintName() {
      return Keys.RECIPIENT_PKEY.getName();
    }

    @Override
    public String[] findParams(Object dataObject) {
      if (dataObject instanceof final RecipientEntity insertData) {
        return new String[] {insertData.kid().toString()};
      } else {
        return new String[] {"null"};
      }
    }
  };

  private final String template;

  RecipientConstraintErrorCode(String template) {
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public String table() {
    return Tables.RECIPIENT.getName();
  }

  @Override
  public abstract String constraintName();
}
