package sk.kosice.konto.kkmessageservice.repository.topic;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static sk.kosice.konto.kkmessageservice.repository.error.DbErrorCode.DB_ERROR;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kkmessageservice.domain.common.error.BusinessException;
import sk.kosice.konto.kkmessageservice.domain.topic.query.FindTopicByIdQuery;

public class JooqTopicRepositoryUpdateTest extends JooqTopicRepositoryTest {

  @Test
  public void thatTopicCanBeUpdated() {
    final var insertData = prepareTopicData();
    persistTopic(topicRepository, insertData);

    final var selected = findTopic(topicRepository, FindTopicByIdQuery.of(insertData));
    assertThat(selected.id()).isEqualTo(insertData.id());
    assertThat(selected.name()).isEqualTo(insertData.name());
    assertThat(selected.description()).isEqualTo(insertData.description());
    assertThat(selected.organizationId()).isEqualTo(insertData.organizationId());

    final var updateData = prepareUpdateTopicData(insertData.id(), insertData.organizationId());
    updateTopic(topicRepository, updateData);

    final var updated = findTopic(topicRepository, FindTopicByIdQuery.of(updateData));
    assertThat(updated.id()).isEqualTo(selected.id());
    assertThat(updated.name()).isEqualTo(updateData.name());
    assertThat(updated.description()).isEqualTo(updateData.description());
    assertThat(updated.organizationId()).isEqualTo(selected.organizationId());
  }

  @Test
  public void thatNotExistingTopicCannotBeUpdated() {
    final BusinessException exception =
        assertThrows(
            BusinessException.class,
            () ->
                updateTopic(
                    topicRepository, prepareUpdateTopicData(UUID.randomUUID(), UUID.randomUUID())));

    assertThat(exception.getError().code().toString()).isEqualTo(DB_ERROR.toString());
  }
}
