import React from 'react';
import type { Metadata } from 'next';
import { getMessages, setRequestLocale } from 'next-intl/server';
import { GoogleAnalytics } from '@next/third-parties/google';
import { Layout, Providers, CookieBanner } from '@/components';
import { auth } from '@/auth';
import { getEnvironment } from '@/utils';
import '../styles/index.css';

export const metadata: Metadata = {
  title: 'Moje Košice',
  description: 'Moje Košice'
};

const RootLayout: React.FC<{ children: React.ReactNode; params: { locale: string } }> = async (props) => {
  const params = await props.params;

  const { locale } = params;
  const { children } = props;

  setRequestLocale(locale);
  const messages = await getMessages();
  const session = await auth();
  const environment = getEnvironment();

  const { gaTag } = environment.config;

  return (
    <html>
      <link rel="manifest" href="/site.webmanifest" />
      <link rel="icon" href="/favicon.ico" type="image/x-icon" sizes="48x48" />
      <link rel="apple-touch-icon" href="/apple-touch-icon.png" type="image/png" sizes="180x180" />
      <meta name="mobile-web-app-capable" content="yes" />
      <meta name="apple-mobile-web-app-status-bar-style" content="default" />
      <meta name="apple-mobile-web-app-title" content="Moje Košice" />
      {gaTag && <GoogleAnalytics gaId={gaTag} />}
      <body className="idsk-text-body">
        <Providers messages={messages} session={session} environment={environment}>
          <Layout>{children}</Layout>
          <CookieBanner />
        </Providers>
      </body>
    </html>
  );
};
export default RootLayout;
