import { z } from 'zod';

const MessageDetailSchema = z.object({
  title: z.string().default('Untitled message'),
  senderName: z.string().default('Unknown sender'),
  createdAt: z.string(),
  tags: z
    .array(
      z.object({
        color: z.string().default('#000000'),
        value: z.string()
      })
    )
    .default([]),
  body: z.string().default(''),
  actions: z.array(z.unknown()).default([])
});

export const validateMessageDetail = (data: any) => MessageDetailSchema.parse(data);
