'use client';

import React, { useState } from 'react';
import { useTranslations } from 'next-intl';
import { Tooltip, DoneIcon, ContentCopyIcon } from '@/lib/idsk';

interface CopyProps {
  value: string;
  children: React.ReactNode;
}

const Copy: React.FC<CopyProps> = ({ value, children }) => {
  const [copied, setCopied] = useState(false);
  const t = useTranslations('utils');

  const handleCopy = () => {
    navigator.clipboard.writeText(value).then(() => setCopied(true));
  };

  const handleReset = () => {
    if (copied) {
      setCopied(false);
    }
  };

  return (
    <div className="flex gap-2 items-center">
      {children}
      <Tooltip tooltip={t('copy')} isInstructive>
        <button
          aria-label={t('copy')}
          type="button"
          className="text-primary-medium hover:outline outline-offset-2 outline-primary"
          onClick={handleCopy}
          onMouseLeave={handleReset}
          onBlur={handleReset}
        >
          {copied ? <DoneIcon /> : <ContentCopyIcon />}
        </button>
      </Tooltip>
    </div>
  );
};

export default Copy;
