// SIGNIN POLICY
export const signInConfig = {
  id: 'microsoft-entra-id',
  issuer: process.env.AZURE_AD_ISSUER,
  clientId: process.env.AZURE_AD_CLIENT_ID,
  clientSecret: process.env.AZURE_AD_CLIENT_SECRET,
  token: {
    url: process.env.AZURE_AD_TOKEN_URL,
    params: {
      p: process.env.AZURE_AD_SIGNIN_POLICY,
      response_type: 'token id_token'
    }
  },
  authorization: {
    url: process.env.AZURE_AD_AUTH_URL,
    params: {
      p: process.env.AZURE_AD_SIGNIN_POLICY,
      scope: process.env.AZURE_AD_SCOPE,
      prompt: 'select_account'
    }
  },

  profile: (profile: any) => ({
    kid: profile.extension_kid,
    email: ''
  })
};

// SIGNUP POLICY
export const signUpConfig = {
  id: 'microsoft-entra-id-signup',
  issuer: process.env.AZURE_AD_ISSUER,
  clientId: process.env.AZURE_AD_CLIENT_ID,
  clientSecret: process.env.AZURE_AD_CLIENT_SECRET,
  token: {
    url: process.env.AZURE_AD_TOKEN_URL,
    params: {
      p: process.env.AZURE_AD_SIGNUP_POLICY,
      response_type: 'token id_token'
    }
  },
  authorization: {
    url: process.env.AZURE_AD_AUTH_URL,
    params: {
      p: process.env.AZURE_AD_SIGNUP_POLICY,
      scope: process.env.AZURE_AD_SCOPE,
      prompt: 'select_account'
    }
  },

  profile: (profile: any) => ({
    kid: profile.extension_kid,
    email: ''
  })
};
