package sk.kosice.konto.kkmessageservice.idp.error;

import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.INTERNAL;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum AzureIdpErrorCode implements ErrorCode {
  AZURE_IDP_EXTERNAL_ERROR(
      INTERNAL, "Error occurred while communicating with Azure IDP, detail: %s.");

  private final ErrorCodeType type;
  private final String template;

  AzureIdpErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
