package sk.kosice.konto.kkmessageservice.repository.provider;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;

import sk.kosice.konto.kkmessageservice.domain.common.listing.TopicListingAttribute;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadata;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataConfigProvider;

public class TopicJooqRsqlMetadataConfigProvider implements JooqRsqlMetadataConfigProvider {

  @Override
  public void configure(JooqRsqlMetadata metadata) {
    metadata
        .addColumnInfo(TopicListingAttribute.NAME.apiName(), TOPIC.NAME)
        .addColumnInfo(TopicListingAttribute.DESCRIPTION.apiName(), TOPIC.DESCRIPTION)
        .addColumnInfo(TopicListingAttribute.ORGANIZATION_ID.apiName(), TOPIC.ORGANIZATION_ID)
        .addColumnInfo(TopicListingAttribute.ORGANIZATION_NAME.apiName(), TOPIC.ORGANIZATION_NAME);
  }
}
