package sk.kosice.konto.kkmessageservice.repository.rsql.collation;

import static sk.kosice.konto.kkmessageservice.repository.rsql.collation.error.MonolingualCollationErrorCode.DB_UNSUPPORTED_DIALECT;
import static sk.kosice.konto.kkmessageservice.repository.rsql.jooq.handler.error.JooqOrderingHandlerErrorCode.LANGUAGE_CODE_NOT_PRESENT;

import com.neovisionaries.i18n.LanguageCode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.jooq.Field;
import org.jooq.SQLDialect;
import sk.kosice.konto.kkmessageservice.domain.common.listing.common.ListingAttribute;
import sk.kosice.konto.kkmessageservice.repository.rsql.collation.common.MonolingualCollation;

public class MonolingualCollationContext {
  private static final HashMap<SQLDialect, MonolingualCollation> collations =
      new HashMap<>() {
        {
          put(SQLDialect.POSTGRES, new PostgresqlMonolingualCollation());
        }
      };

  public static Field<?> getCollationTemplate(
      SQLDialect dialect,
      Field<?> field,
      ListingAttribute listingAttribute,
      LanguageCode... languageCodes) {
    MonolingualCollation collation;
    if (dialect == null || (collation = collations.get(dialect)) == null) {
      throw DB_UNSUPPORTED_DIALECT.createError(dialect).convertToException();
    }

    final Optional<String> language =
        Arrays.stream(languageCodes)
            .map(collation::getCollation)
            .filter(Objects::nonNull)
            .findFirst();
    if (language.isEmpty()) {
      throw LANGUAGE_CODE_NOT_PRESENT.createError(listingAttribute.apiName()).convertToException();
    }

    return collation.getCollatedAttribute(field, language.get());
  }
}
