package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata;

import java.util.Optional;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableField;
import sk.kosice.konto.kkmessageservice.repository.rsql.converter.FieldValueConverter;

public interface JooqRsqlMetadata {

  <T> JooqRsqlMetadata addColumnInfo(String name, Field<T> field);

  <T> JooqRsqlMetadata addColumnInfo(String name, Field<T> field, FieldValueConverter<T> converter);

  <T> JooqRsqlMetadata addColumnInfo(String name, JooqColumnInfo<T> info);

  <R extends Record, T> JooqRsqlMetadataOnStep addJoinableColumnInfo(
      String name, TableField<R, T> field);

  <R extends Record, T> JooqRsqlMetadataOnStep addJoinableColumnInfo(
      String name, TableField<R, T> field, FieldValueConverter<T> converter);

  <R extends Record, T> JooqRsqlMetadataOnStep addJoinableColumnInfo(
      String name, JooqJoinableColumnInfo<R, T> info);

  JooqRsqlMetadata registerConverter(FieldValueConverter converter);

  Optional<JooqColumnInfo<?>> findByName(String name);
}
