package sk.kosice.konto.kkmessageservice.repository.recipient;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static sk.kosice.konto.kkmessageservice.domain.recipient.error.RecipientErrorCode.RECIPIENT_DOES_NOT_EXIST;
import static sk.kosice.konto.kkmessageservice.repository.recipient.error.constraint.RecipientConstraintErrorCode.RECIPIENT_WITH_ID_ALREADY_EXISTS;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kkmessageservice.domain.common.error.BusinessException;
import sk.kosice.konto.kkmessageservice.domain.recipient.entity.RecipientEntity;

public class JooqRecipientRepositoryFindTest extends JooqRecipientRepositoryTest {

  @Test
  public void thatRecipientCanBeInsertedAndSelected() {
    final RecipientEntity insertData = prepareRecipientData();
    final RecipientEntity result = persistAndFindRecipient(recipientRepository, insertData);

    assertThat(result).isNotNull();
    assertThat(result.kid()).isEqualTo(insertData.kid());
    assertThat(result.email()).isEqualTo(insertData.email());
  }

  @Test
  public void thatRecipientWithDuplicatedIdCanNotBeInserted() {
    final RecipientEntity insertData = prepareRecipientData();
    persistRecipient(recipientRepository, insertData);

    final BusinessException exception =
        assertThrows(
            BusinessException.class, () -> persistRecipient(recipientRepository, insertData));

    assertThat(exception.getError().code().toString())
        .isEqualTo(RECIPIENT_WITH_ID_ALREADY_EXISTS.name());
  }

  @Test
  public void thatNotExistingRecipientCannotBeSelected() {
    final BusinessException exception =
        assertThrows(
            BusinessException.class, () -> findRecipient(recipientRepository, UUID.randomUUID()));

    assertThat(exception.getError().code().toString())
        .isEqualTo(RECIPIENT_DOES_NOT_EXIST.toString());
  }
}
