package sk.kosice.konto.kkmessageservice.repository.recipient;

import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.recipient.entity.ImmutableRecipientEntity;
import sk.kosice.konto.kkmessageservice.domain.recipient.entity.RecipientEntity;

public interface JooqRecipientRepositoryTestSupport {

  default ImmutableRecipientEntity prepareRecipientData() {
    return ImmutableRecipientEntity.builder()
        .kid(UUID.randomUUID())
        .email("ferko@kosice.sk")
        .build();
  }

  default ImmutableRecipientEntity prepareRecipientData(UUID kid) {
    return prepareRecipientData().withKid(kid);
  }

  default void persistRecipient(JooqRecipientRepository repository, RecipientEntity insertData) {
    repository.insert(insertData);
  }

  default RecipientEntity findRecipient(JooqRecipientRepository repository, UUID kid) {
    return repository.findOne(kid);
  }

  default RecipientEntity persistAndFindRecipient(
      JooqRecipientRepository repository, RecipientEntity insertData) {
    persistRecipient(repository, insertData);
    return findRecipient(repository, insertData.kid());
  }
}
