package sk.kosice.konto.kkmessageservice.repository.subscription;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static sk.kosice.konto.kkmessageservice.repository.subscription.error.constraint.SubscriptionConstraintErrorCode.SUBSCRIPTION_WITH_ID_ALREADY_EXISTS;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kkmessageservice.domain.common.error.BusinessException;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.BaseOrganization;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.BaseTopic;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ImmutableSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;

public class JooqSubscriptionRepositoryInsertTest extends JooqSubscriptionRepositoryTest {

  @Test
  public void thatSubscriptionsCanBeInserted() {
    final var topics = prepareTopics();
    final UUID recipientKid = prepareRecipient();

    subscriptionRepository.insert(
        ImmutableSubscriptionEntity.builder()
            .id(UUID.randomUUID())
            .isEmailEnabled(false)
            .recipientKid(recipientKid)
            .topic(new BaseTopic(topics.getFirst(), null, null))
            .organization(new BaseOrganization(null, null))
            .build());
    final List<SubscriptionEntity> result = findSubscriptions(subscriptionRepository, recipientKid);

    assertThat(result).isNotNull().isNotEmpty().hasSize(1);
    assertThat(result.getFirst().topic().id()).isEqualTo(topics.getFirst());
    assertThat(result.getFirst().recipientKid()).isEqualTo(recipientKid);
  }

  @Test
  public void thatExistingSubscriptionsCannotBeInserted() {
    final var topics = prepareTopics();
    final UUID recipientKid = prepareRecipient();
    final var subscriptionEntity =
        ImmutableSubscriptionEntity.builder()
            .id(UUID.randomUUID())
            .isEmailEnabled(false)
            .recipientKid(recipientKid)
            .topic(new BaseTopic(topics.getFirst(), null, null))
            .organization(new BaseOrganization(null, null))
            .build();

    subscriptionRepository.insert(subscriptionEntity);
    final List<SubscriptionEntity> result = findSubscriptions(subscriptionRepository, recipientKid);

    assertThat(result).isNotNull().isNotEmpty().hasSize(1);
    assertThat(result.getFirst().topic().id()).isEqualTo(topics.getFirst());
    assertThat(result.getFirst().recipientKid()).isEqualTo(recipientKid);

    final var ex =
        assertThrows(
            BusinessException.class, () -> subscriptionRepository.insert(subscriptionEntity));
    assertThat(ex.getError().code()).isEqualTo(SUBSCRIPTION_WITH_ID_ALREADY_EXISTS);
  }
}
