package sk.kosice.konto.kkmessageservice.repository.topic;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static sk.kosice.konto.kkmessageservice.domain.topic.error.TopicErrorCode.TOPIC_DOES_NOT_EXIST;
import static sk.kosice.konto.kkmessageservice.repository.error.DbErrorCode.DB_ERROR;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kkmessageservice.domain.common.error.BusinessException;
import sk.kosice.konto.kkmessageservice.domain.topic.query.FindTopicByIdQuery;

public class JooqTopicRepositoryDeleteTest extends JooqTopicRepositoryTest {

  @Test
  public void thatTopicCanBeDeleted() {
    final var insertData = prepareTopicData();
    persistTopic(topicRepository, insertData);

    final var selected = findTopic(topicRepository, FindTopicByIdQuery.of(insertData));
    assertThat(selected.id()).isEqualTo(insertData.id());
    assertThat(selected.name()).isEqualTo(insertData.name());
    assertThat(selected.description()).isEqualTo(insertData.description());
    assertThat(selected.organizationId()).isEqualTo(insertData.organizationId());

    final var updateData = prepareDeleteTopicData(insertData.id(), insertData.organizationId());
    deleteTopic(topicRepository, updateData);

    final BusinessException exception =
        assertThrows(
            BusinessException.class,
            () ->
                findTopic(
                    topicRepository,
                    FindTopicByIdQuery.of(insertData.id(), insertData.organizationId())));

    assertThat(exception.getError().code().toString()).isEqualTo(TOPIC_DOES_NOT_EXIST.toString());
  }

  @Test
  public void thatNotExistingTopicCannotBeDeleted() {
    final BusinessException exception =
        assertThrows(
            BusinessException.class,
            () ->
                deleteTopic(
                    topicRepository, prepareDeleteTopicData(UUID.randomUUID(), UUID.randomUUID())));

    assertThat(exception.getError().code().toString()).isEqualTo(DB_ERROR.toString());
  }
}
