package sk.kosice.konto.kkmessageservice.restapi.dto.common.listing;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(
    description = "Special type of response representing a list of fetched items of specific type.")
public interface ListingResponse<T> {

  @Schema(description = "A list of fetched items.", requiredMode = REQUIRED, type = "array")
  List<T> items();

  @Schema(
      description = "Total count of listed items.",
      format = "integer",
      requiredMode = REQUIRED,
      example = "1")
  Integer totalCount();

  @Schema(
      description = "A number of the page to fetch.",
      format = "integer",
      requiredMode = REQUIRED,
      example = "1")
  Integer page();

  @Schema(
      description = "Maximum number of items fetched in one page.",
      format = "integer",
      requiredMode = REQUIRED,
      example = "1")
  Integer pageSize();
}
