package sk.kosice.konto.kkmessageservice.restapi.error;

import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCode;
import sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType;

public enum ApiErrorCode implements ErrorCode {
  BAD_JSON_FORMAT(ErrorCodeType.BAD_REQUEST, "Invalid json format."),
  BAD_REQUEST(ErrorCodeType.BAD_REQUEST, "Invalid request parameters.");

  private final ErrorCodeType type;
  private final String template;

  ApiErrorCode(ErrorCodeType type, String template) {
    this.type = type;
    this.template = template;
  }

  @Override
  public String template() {
    return this.template;
  }

  @Override
  public ErrorCodeType type() {
    return this.type;
  }
}
