package sk.kosice.konto.kkmessageservice.domain.common.error;

import java.util.List;
import org.immutables.value.Value;

/**
 * Specific error code for building parental Business error. Business error can contain more nested
 * error codes returned from external system (i.e calling 3th part API). Nested errors describe
 * cause of failing in external systems and provide more detailed information.
 */
@Value.Immutable
public abstract class NestedBusinessError {

  /**
   * Gets unique identifier (name) of the microservice or external service that generated the given
   * error.
   *
   * @return service Id of microservice or external service
   */
  @Value.Parameter
  public abstract String serviceId();

  /**
   * Gets unique identifier of the error.
   *
   * @return fault error code
   */
  @Value.Parameter
  public abstract String faultCode();

  /**
   * Gets error description in more detail. The whole message can be compiled using a list of items
   * in faultMessageParams.
   *
   * @return fault error message
   */
  @Value.Parameter
  public abstract String faultMessage();

  /**
   * Returns list of additional parameters to describe the error. These parameters can be used to
   * create full error message using faultMessage string.
   *
   * @return list of fault message params
   */
  @Value.Parameter
  public abstract List<String> faultMessageParams();
}
