package sk.kosice.konto.kkmessageservice.domain.subscription.query;

import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.marker.Query;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;

@Value.Immutable
public interface FindSubscriptionByIdQuery extends Query {

  UUID recipientKid();

  UUID id();

  static FindSubscriptionByIdQuery of(UUID id, UUID recipientKid) {
    return ImmutableFindSubscriptionByIdQuery.builder().recipientKid(recipientKid).id(id).build();
  }

  static FindSubscriptionByIdQuery of(SubscriptionEntity entity) {
    return ImmutableFindSubscriptionByIdQuery.builder()
        .recipientKid(entity.recipientKid())
        .id(entity.id())
        .build();
  }
}
