import { cookies } from 'next/headers';
import { getBuildInfo } from '@/lib/server';

export const GET = async () => {
  const version = getBuildInfo().version;
  const cookieStore = await cookies();
  const cookieVersion = cookieStore.get('kk-version')?.value;

  if (!cookieVersion) {
    cookieStore.set('kk-version', version);
  }

  const forceReload = !!Number(process.env.FORCE_RELOAD);
  const isUpToDate = cookieVersion === version;

  const result = JSON.stringify({
    version: version,
    isUpToDate,
    forceReload: forceReload && !isUpToDate
  });

  const response = new Response(result, {
    status: 200,
    headers: {
      'Content-Type': 'application/json',
      'Cache-Control': 'no-cache, no-store, must-revalidate, proxy-revalidate'
    }
  });

  if (!cookieVersion || !isUpToDate) {
    response.headers.append('Set-Cookie', `kk-version=${version}; Path=/; HttpOnly; Secure; SameSite=Lax`);
  }

  return response;
};
