import React from 'react';
import { MessageAction } from '@/utils';

interface PayBySquareActionProps {
  action: MessageAction;
}

const GenericAction: React.FC<PayBySquareActionProps> = ({ action }) => (
  <div className="p-5 rounded bg-neutral-90 border border-neutral-300">
    <h4 className="mb-5">{action.title}</h4>
    <p className="w-8/12">{action.desc}</p>

    {!!action.metadata?.length && (
      <div className="mt-10 w-full">
        {action.metadata.map((metadata: any) => (
          <p key={metadata.id}>
            <span>{metadata.key}</span> <b>{metadata.value}</b>
          </p>
        ))}
      </div>
    )}
  </div>
);
export default GenericAction;
