'use client';

import React from 'react';
import { DataGridRowValue } from '@/lib/idsk';
import { useBreakpoint } from '@/hooks';

const MessageListHeader: React.FC = () => {
  const { match, Breakpoints } = useBreakpoint();
  const isDesktop = match(Breakpoints.dm1);
  const isTablet = match(Breakpoints.tb2);

  return isTablet ? (
    <>
      <DataGridRowValue className="tb1:w-[16rem] flex-none">Odosielateľ</DataGridRowValue>
      <DataGridRowValue className="w-full">Predmet</DataGridRowValue>
      {isDesktop && <DataGridRowValue className="w-full" />}
      <DataGridRowValue align="right" className="w-[10rem] flex-none">
        Dátum
      </DataGridRowValue>
    </>
  ) : (
    <DataGridRowValue>Odosielateľ/Predmet/Dátum</DataGridRowValue>
  );
};

export default MessageListHeader;
