'use client';

import React, { useCallback, useState } from 'react';
import { useTranslations } from 'next-intl';
import { Loader, Table, TableRowValue } from '@/lib/idsk';
import { Proceeding } from '@/utils';
import { Empty, TableList } from '@/components/core';
import ProceedingItem from './ProceedingItem';
import ProceedingPayDialog from './ProceedingPayDialog';

interface ProceedingsProps {
  view: 'table' | 'list';
  type: 'tax' | 'payment';
  status: string;
  items: Proceeding[];
}

const Proceedings: React.FC<ProceedingsProps> = ({ items, type, view, status }) => {
  const [itemToPay, setItemToPay] = useState<Proceeding | null>(null);
  const t = useTranslations('taxes');

  const handleOnPay = useCallback((item: Proceeding) => {
    setItemToPay(item);
  }, []);

  if (status === 'pending') {
    return (
      <div className="px-6 py-12 flex items-center justify-center w-full">
        <Loader />
      </div>
    );
  }

  if (!items.length) {
    return <Empty title={t(`${type}_empty_title`)} description={t(`${type}_empty_description`)} />;
  }

  return (
    <>
      <ProceedingPayDialog item={itemToPay} onClose={() => setItemToPay(null)} />
      {view === 'table' && (
        <Table
          className="taxes-table"
          headRowBordered
          headRow={
            <>
              <TableRowValue className="w-[25%] tb2:w-[25%] dm1:w-[20%]">{t(`name_of_${type}`)}</TableRowValue>
              <TableRowValue className="w-[21%] tb2:w-[20%] dm1:w-[15%]">{t('date_of_issue')}</TableRowValue>
              <TableRowValue className="w-[17%] tb2:w-[22%] dm1:w-[11%]">{t('sum')}</TableRowValue>
              <TableRowValue className="w-[17%] tb2:w-[21%] dm1:w-[11%]">{t('paid')}</TableRowValue>
              <TableRowValue className="w-[13%] tb2:w-[12%] dm1:w-[43%]" />
            </>
          }
        >
          {items.map((item) => (
            <ProceedingItem type={type} view={view} key={item.id} item={item} onPay={handleOnPay} />
          ))}
        </Table>
      )}
      {view === 'list' && (
        <TableList>
          {items.map((item) => (
            <ProceedingItem type={type} view={view} key={item.id} item={item} onPay={handleOnPay} />
          ))}
        </TableList>
      )}
    </>
  );
};

export default Proceedings;
