'use client';

import { createContext, useContext } from 'react';

export const EnvironmentContext = createContext<Record<string, any> | null>(null);

export const useEnvironment = () => {
  const ctx = useContext(EnvironmentContext);
  if (!ctx) {
    throw new Error('useEnvironment must be used within a EnvironmentProvider');
  }
  return ctx;
};
