'use client';

import { useMemo } from 'react';
import { hexToRgb, overlayColor, RGB, rgbToString } from '@/utils';

const useTagTheme = (color: string) => {
  const theme = useMemo(() => {
    const baseColorRGB: RGB = hexToRgb(color);
    return {
      text: rgbToString(overlayColor(baseColorRGB, -40)),
      background: rgbToString(overlayColor(baseColorRGB, 90)),
      border: rgbToString(overlayColor(baseColorRGB, 70))
    };
  }, [color]);

  return theme;
};

export default useTagTheme;
