import { withAuthMiddleware } from '@/middleware/with-auth-middleware';
import { withIntlMiddleware } from '@/middleware/with-intl-middleware';
import { chain } from '@/middleware/chain';

export default chain([withAuthMiddleware, withIntlMiddleware]);

export const config = {
  matcher: [
    '/',
    '/(sk|en)/:path*',
    // Apply middleware to all routes except Next.js internals, API routes, and static files
    '/((?!_next/static|_next/image|favicon.ico|api/|version.json|apple-touch-icon.png|favicon-96x96.png|web-app-manifest-192x192.png|web-app-manifest-512x512.png|site.webmanifest).*)'
  ]
};
