import React from 'react';
import { cn } from '@/utils';

interface DataProps {
  children?: React.ReactNode;
}

interface DataItemProps {
  label: string;
  children: React.ReactNode;
  className?: string;
  labelClassName?: string;
  childrenClassName?: string;
}

export const DataItem: React.FC<DataItemProps> = ({
  label,
  children,
  className,
  labelClassName,
  childrenClassName
}) => (
  <li className={cn('flex gap-4 tb2:gap-0', className)}>
    <span className={cn('block mb:inline-block w-1/2 mb:w-1/3 tb2:w-1/5', labelClassName)}>{`${label}:`}</span>
    <b className={cn('w-1/2 mb:w-2/3 tb2:w-4/5', childrenClassName)}>{children}</b>
  </li>
);

const Data: React.FC<DataProps> = ({ children }) => <ul className="idsk-text-body flex flex-col gap-3">{children}</ul>;

export default Data;
