import React from 'react';
import NextLink from 'next/link';
import { OpenInNewIcon } from '@/lib/idsk';
import { cn } from '@/utils';

interface LinkProps extends React.ComponentProps<typeof NextLink> {
  external?: boolean;
}

const Link: React.FC<LinkProps> = ({ children, className, external = false, ...props }) => (
  <NextLink
    className={cn('idsk-link-m flex gap-3 items-center', className)}
    {...(external ? { target: '_blank' } : {})}
    {...props}
  >
    {children}
    {external ? <OpenInNewIcon /> : null}
  </NextLink>
);

export default Link;
