import React from 'react';
import { useSession } from 'next-auth/react';
import { IUser } from '@/utils';

interface WithUserProps {
  children: (user: IUser) => React.ReactNode;
  fallback?: React.ReactNode;
}

const WithUser: React.FC<WithUserProps> = ({ children, fallback }) => {
  const { data } = useSession();

  const user = !data?.error && data?.user;
  return user ? children(user) : fallback;
};

export default WithUser;
