'use client';

import React from 'react';
import { useRouter } from 'next/navigation';
import { useTranslations } from 'next-intl';
import { HorizontalNavigationItem, ArrowBackIcon } from '@/lib/idsk';

const MessageBackButton: React.FC = () => {
  const t = useTranslations('messages');
  const router = useRouter();

  return (
    // @ts-ignore
    <HorizontalNavigationItem icon={<ArrowBackIcon />} onClick={() => router.back()}>
      {t('back')}
    </HorizontalNavigationItem>
  );
};

export default MessageBackButton;
