'use client';

import React from 'react';
import { useLocale, useTranslations } from 'next-intl';
import { usePathname } from 'next/navigation';
import { NavigationLink } from '@/lib/idsk';
import { useLocalLink } from '@/hooks';

const PrimaryNavigation: React.FC = () => {
  const t = useTranslations();
  const href = useLocalLink();
  const pathname = usePathname();
  const locale = useLocale();

  const isSelected = (path: string) => {
    const currentPath = pathname.replace(`/${locale}`, '');

    if (path === '/' && currentPath === '') return true;
    return currentPath === path || currentPath.startsWith(`${path}/`);
  };
  return (
    <>
      <NavigationLink href={href('/')} label={t('dashboard')} selected={isSelected('/')} />
      <NavigationLink href={href('/spravy')} label={t('mailbox')} selected={isSelected('/spravy')} />
      <NavigationLink
        href={href('/dane-a-poplatky')}
        label={t('taxes_and_payments')}
        selected={isSelected('/dane-a-poplatky')}
      />
      <NavigationLink href={href('/moje-udaje')} label={t('my_information')} selected={isSelected('/moje-udaje')} />
      <NavigationLink href={href('/preferencie')} label={t('profile')} selected={isSelected('/preferencie')} />
    </>
  );
};

export default PrimaryNavigation;
