import { LOCALES, DEFAULT_LOCALE } from '@/i18n/routing';
import { CustomMiddleware } from './chain';
import { NextRequest, NextFetchEvent, NextResponse } from 'next/server';
import createMiddleware from 'next-intl/middleware';

export function withIntlMiddleware(middleware: CustomMiddleware): CustomMiddleware {
  return async (
    request: NextRequest,
    event: NextFetchEvent,

    response: NextResponse
  ) => {
    const handleI18Routing = createMiddleware({
      locales: LOCALES,
      defaultLocale: DEFAULT_LOCALE
    });

    const res = handleI18Routing(request);
    return middleware(request, event, res);
  };
}
